/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.AbstractStoreView;
import cz.insophy.inplan.store.StoreSchedule;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MergingStoreView
extends AbstractStoreView {
    private final Collection<StoreSchedule> storeSchedules;

    public MergingStoreView(Collection<StoreSchedule> storeSchedules) {
        super(storeSchedules.iterator().next().getMaterials(), storeSchedules);
        this.storeSchedules = storeSchedules;
    }

    public MergingStoreView(StoreSchedule ... schedules) {
        this((Collection<StoreSchedule>)Lists.newArrayList(schedules));
    }

    @Override
    protected void createCache(Material m3) {
        List actList = (List)this.activities.get(m3);
        actList.clear();
        for (StoreSchedule ss : this.storeSchedules) {
            actList.addAll(ss.getActivities(m3));
        }
        Collections.sort(actList);
    }

    @Override
    public StoreSchedule copyStoreStructure() {
        return new MergingStoreView(Collections2.transform(this.storeSchedules, new Function<StoreSchedule, StoreSchedule>(){

            @Override
            public StoreSchedule apply(StoreSchedule from) {
                return from.copyStoreStructure();
            }
        }));
    }
}

